// RadiusClt1.h: interface for the RadiusClt class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(__RADIUSCLT_H__)
#define __RADIUSCLT_H__

//#if _MSC_VER > 1000
//#pragma once
//#endif // _MSC_VER > 1000
#define		MAX_HOSTLEN					20		//ip󳤶(*.*.*.*ʽ)
#define		MAX_SHARELEN				20		//Կ󳤶
#define		MAX_PWDLEN					128		//󳤶
#define		MAX_PACKETLEN				512		//󳤶
#define		RD_ERROR_SUCCESS			0		//ɹ
#define		RD_ERROR_INVALID_USERNAME	-1		//û
#define		RD_ERROR_INVALID_PWD		-2		//벻
#define		RD_ERROR_INVALIDHOST		-3		//֤񲻿
#define		RD_ERROR_INVALIDPCNAME		-4		//õʧ
#define		RD_ERROR_GENRAFAILED		-5		//֤ʧ
#define		RD_ERROR_GENPWDFAILED		-6		//ʧ
#define		RD_ERROR_CREATEPKTFAILED	-7		//֤ݰʧ
#define		RD_ERROR_CREATESOCKETFAILED -8		//ʼ׽ʧ
#define		RD_ERROR_SENDDATAFAILED		-9		//ʧ
#define		RD_ERROR_RECVDATAFAILED		-10		//ʧ
#define		RD_ERROR_INVALIDPKT			-11		//Чݰ
#define		RD_ERROR_NORESPONSE			-12		//Ӧ
#define		RD_ERROR_AUTHFAILED			-13		//ʧ
#define		RD_ERROR_GETCHALLENGEFAILED -14		//սʧ
#define     RD_ERROR_REMOTESOCKETCLOSED -15		//׽ֹر
#define     RD_ERROR_INITSOCKFAILED		-16		//wsastartupʧ(win)
#define		RD_ERROR_INVALIDCONFIGFILE	-17		//ļ·

#define		RD_ERROR_CHALLENGENEED		1		//ҪӦս


//////////////////////////////////////////////////////////
#define		RD_REQUESTCODE_AUTH		1		//
#define		RD_REQUESTCODE_ACCEPT	2		//֤ɹ
#define		RD_REQUESTCODE_REJECT	3		//ܾ
#define		RD_REQUESTCODE_CHALLENGE 11		//սӦ

#ifndef NULL
#define NULL 0
#endif
#ifndef SOCKET_ERROR
#define SOCKET_ERROR -1
#endif

////////////////////////////////////////////////////////////////////////////////////////////////
// Class RadiusClt
// remark: ֤֯ݽ֤,֤.ʹ÷Ϊ
//		  1ʵ(Ĺ캯Ҫṩ:֤IPԿԿȡ֤˿ں)
//
//////////////////////////////////////////////////////////////////////////////////////////////////

class RadiusClt  
{
public:
	RadiusClt();
	RadiusClt(char *pHost, char *pshare, int nsharelen, unsigned short uPort = 1812, int nwaittime = 3);
	virtual ~RadiusClt();
	int parase(char *pUsername, int namelen, char *pPwd, int pwdlen);
	
	int initrad(char *pHost, char *pshare, int nsharelen, unsigned short uPort = 1812, int nwaittime = 3);
	int auth(int &nchallenge, int &bvalidresponse, char *pszresponse = NULL, int nmaxbuflen = 0);
	
private:
	int getpcname(char *pbuf, int len);
	int createauthpkt();
	void setattr(int atttype, unsigned char *pval, int vallen, int& noffset);
	bool genpwd(unsigned char *pra, unsigned char *pshare, int nshrelen, unsigned char *pinpwd, int ninpwdlen, unsigned char *poutpwd, int& noutpwdlen);
	bool checkpktvalid(unsigned char *precvpkt);
	bool getchallenge(unsigned char *pattr,  int npktlen, int &nchg, int &bvalidresponse, char *pszresponse = NULL, int nmaxbuflen = 0);
	//data
	unsigned char m_ra[16];
	//ȴʱ
	int m_nwaittime;

	unsigned char m_share[MAX_SHARELEN+1];
	int m_nsharelen;
	char m_host[MAX_HOSTLEN+1];
	char m_username[MAX_HOSTLEN+1];
	int m_nusernamelen;
	char m_userpwd[MAX_HOSTLEN+1];
	int m_nuserpwdlen;
	char m_hostpcname[2*MAX_HOSTLEN+1];
	unsigned char m_authpkt[MAX_PACKETLEN+1];
	unsigned short m_port;
	bool m_bvalidhost;
	bool m_bvalidpcname;
	int m_npacketlen;

};

#endif // !defined(__RADIUSCLT_H__)
